#pragma once

#include "encoder.h"

#include <solomon/libs/cpp/string_map/string_map.h>

#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/monlib/metrics/metric_consumer.h>

#include <util/datetime/base.h>
#include <util/generic/hash.h>
#include <util/generic/string.h>

namespace NSolomon::NFetcher::NYasm {

constexpr TStringBuf COMMON_TYPE = TStringBuf("common");

using TYasmTag = NMonitoring::TLabel;

using TYasmCommonRule = TVector<TVector<TYasmTag>>;

using TRuleMap = TStringMap<TYasmCommonRule>;

const TRuleMap& GetCommonRulesTable(TStringBuf path);
const TRuleMap& GetCommonRulesTable();

// TODO: do not pretend to be an encoder
class TCommonRulesMatchTagsConsumer: public IMultiShardEncoder {
public:
    TCommonRulesMatchTagsConsumer(const TYasmCommonRule& rule)
        : Rule_(rule)
    {
        if (rule.empty()) {
            Initialized_ = true;
            Match_ = true;
        }

        Matchs_.resize(Rule_.size(), 0u);
    }

    void AddShard(TYasmShardKey) override {}
    void SwitchShards() override {}

    void WriteLabel(TStringBuf name, TStringBuf value) override {
        Initialized_ = true;
        if (Match_) {
            return;
        }

        for (size_t i = 0; i < Rule_.size(); ++i) {
            OnLabel(name, value, i);
        }
    }

    bool SupportedValue(const ::NYasm::NInterfaces::NInternal::TValue&) override { return true; }
    void WriteValue(const ::NYasm::NInterfaces::NInternal::TValue&) override {}

    void Close(IDataConsumer*) override {}

    bool Match() const {
        Y_ENSURE(Initialized_, "TCommonMatchTagsConsumer not initialized");
        return Match_;
    }

    void Reset() {
        Initialized_ = false;
        Match_ = false;

        std::fill(Matchs_.begin(), Matchs_.end(), 0u);
    }

private:
    const TYasmCommonRule& Rule_;
    TVector<size_t> Matchs_;

    bool Initialized_{false};
    bool Match_{false};

    void OnLabel(TStringBuf name, TStringBuf value, size_t i) {
        for (const auto& tag: Rule_[i]) {
            if (tag.Name() == name && tag.Value() == value) {
                ++Matchs_[i];
                if (Matchs_[i] == Rule_[i].size()) {
                    Match_ = true;
                }

                return;
            }
        }
    }
};

} // namespace NSolomon::NFetcher::NYasm
