#pragma once

#include "shard_key.h"

#include <library/cpp/monlib/encode/format.h>

namespace NYasm::NInterfaces::NInternal {
class TValue;
} // namespace NYasm::NInterfaces::NInternal

namespace NSolomon::NFetcher::NYasm {

class IDataConsumer {
public:
    virtual ~IDataConsumer() = default;
    virtual void OnShardData(TYasmShardKey key, TString data) = 0;
};

class IMultiShardEncoder {
public:
    virtual ~IMultiShardEncoder() = default;

    virtual void AddShard(TYasmShardKey key) = 0;
    virtual void SwitchShards() = 0;

    virtual bool SupportedValue(const ::NYasm::NInterfaces::NInternal::TValue& value) = 0;
    virtual void WriteLabel(TStringBuf name, TStringBuf value) = 0;
    virtual void WriteValue(const ::NYasm::NInterfaces::NInternal::TValue& value) = 0;

    virtual void Close(IDataConsumer* handler) = 0;
};

THolder<IMultiShardEncoder> CreateMultiShardEncoder(NMonitoring::ECompression compression);

} // namespace NSolomon::NFetcher::NYasm
