#include <solomon/services/fetcher/lib/yasm/encoder.h>
#include <solomon/services/fetcher/lib/yasm/message_string_pool.h>
#include <solomon/services/fetcher/lib/yasm/yasm_decoder.h>

#include <solomon/libs/cpp/yasm/shard_config/shard_config.h>

#include <infra/yasm/interfaces/internal/agent.pb.h>

#include <library/cpp/resource/resource.h>
#include <library/cpp/monlib/encode/fake/fake.h>

#include <contrib/libs/protobuf-mutator/src/libfuzzer/libfuzzer_macro.h>

DEFINE_PROTO_FUZZER(const ::NYasm::NInterfaces::NInternal::TAgentResponse agentResponse) {
    using namespace NSolomon::NFetcher::NYasm;
    using namespace NSolomon::NYasm;

    try {
        auto shardConfig = CreateShardConfig(NResource::Find("yasm_shards.conf"));
        auto encoder = CreateMultiShardEncoder(NMonitoring::ECompression::IDENTITY);

        DecodeYasmAgentResponse(
            agentResponse.GetPerInstanceRecords(),
            agentResponse.GetAggregatedRecords(),
            *shardConfig,
            std::move(encoder)
        );
    } catch (...) {
    }
}
