#pragma once

#include <library/cpp/monlib/metrics/histogram_collector.h>

namespace NSolomon::NFetcher::NYasm {
    class THistogramBuilder {
    public:
        explicit THistogramBuilder(size_t capacity) noexcept {
            Bounds.reserve(std::min<size_t>(capacity, NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT));
            Values.reserve(std::min<size_t>(capacity, NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT));
        }

        void Add(NMonitoring::TBucketBound bound, NMonitoring::TBucketValue value) {
            Bounds.push_back(bound);
            Values.push_back(value);
        }

        size_t Size() const {
            return Bounds.size();
        }

        NMonitoring::IHistogramSnapshotPtr Finalize(NMonitoring::TBucketValue infValue = 0) {
            using namespace NMonitoring;

            // yasm ugrams always have some upper bound, so our inf usually is 0
            Bounds.push_back(HISTOGRAM_INF_BOUND);
            Values.push_back(infValue);

            Y_ENSURE(Size() <= HISTOGRAM_MAX_BUCKETS_COUNT,
                "Histogram is only allowed to have " << HISTOGRAM_MAX_BUCKETS_COUNT << " buckets, but has " << Bounds.size());

            return ExplicitHistogramSnapshot(std::move(Bounds), std::move(Values));
        }

    public:
        NMonitoring::TBucketBounds Bounds;
        NMonitoring::TBucketValues Values;
    };
} // namespace NSolomon::NFetcher::NYasm
