#include "itype_white_list.h"

#include <unordered_set>

namespace NSolomon::NFetcher {

class TCombList: public IYasmItypeWhiteList {
public:
    TCombList(IYasmItypeWhiteListPtr ft, IYasmItypeWhiteListPtr sd)
        : Ft_(std::move(ft))
        , Sd_(std::move(sd))
    {
    }

    bool Contain(TStringBuf itype) const override {
        return (!Ft_ || Ft_->Contain(itype)) && (!Sd_ || Sd_->Contain(itype));
    }

private:
    IYasmItypeWhiteListPtr Ft_;
    IYasmItypeWhiteListPtr Sd_;
};

class TYasmItypeBlackList: public IYasmItypeWhiteList {
public:
    TYasmItypeBlackList(const TVector<TString>& itypes)
        : BlackList_(itypes.begin(), itypes.end())
    {
    }

    bool Contain(TStringBuf itype) const override {
        return BlackList_.find(TString{itype}) == BlackList_.end();
    }

private:
    std::unordered_set<TString> BlackList_;
};

class TYasmItypeWhiteList: public IYasmItypeWhiteList {
public:
    TYasmItypeWhiteList(const TVector<TString>& itypes)
        : WhiteList_(itypes.begin(), itypes.end())
    {}

    bool Contain(TStringBuf itype) const override {
        return WhiteList_.find(TString{itype}) != WhiteList_.end();
    }

private:
    std::unordered_set<TString> WhiteList_;
};

class TFakeYasmItypeWhiteList: public IYasmItypeWhiteList {
public:
    bool Contain(TStringBuf) const override {
        return true;
    }
};

IYasmItypeWhiteListPtr MakeYasmItypeWhiteList(const TVector<TString>& itypes) {
    return MakeIntrusive<TYasmItypeWhiteList>(itypes);
}

IYasmItypeWhiteListPtr MakeFakeYasmItypeWhiteList() {
    return MakeIntrusive<TFakeYasmItypeWhiteList>();
}

IYasmItypeWhiteListPtr MakeYasmItypeBlackList(const TVector<TString>& itypes) {
    return MakeIntrusive<TYasmItypeBlackList>(itypes);
}

IYasmItypeWhiteListPtr CombYasmWhiteLists(IYasmItypeWhiteListPtr ft, IYasmItypeWhiteListPtr sd) {
    return MakeIntrusive<TCombList>(std::move(ft), std::move(sd));
}

} // namespace NSolomon::NFetcher
