#pragma once

#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NSolomon::NFetcher {

constexpr TStringBuf DEFAULT_YASM_PREFIX = "yasm_pull_";

class IYasmItypeWhiteList: public TThrRefBase {
public:
    virtual bool Contain(TStringBuf itype) const = 0;

    virtual ~IYasmItypeWhiteList() = default;
};

using IYasmItypeWhiteListPtr = TIntrusivePtr<IYasmItypeWhiteList>;

IYasmItypeWhiteListPtr MakeYasmItypeWhiteList(const TVector<TString>& itypes);

IYasmItypeWhiteListPtr MakeFakeYasmItypeWhiteList();

IYasmItypeWhiteListPtr MakeYasmItypeBlackList(const TVector<TString>& itypes);

IYasmItypeWhiteListPtr CombYasmWhiteLists(IYasmItypeWhiteListPtr ft, IYasmItypeWhiteListPtr sd);

} // namespace NSolomon::NFetcher
