#include "message_string_pool.h"

#include <infra/yasm/interfaces/internal/agent.pb.h>

using namespace ::NYasm::NInterfaces::NInternal;

namespace NSolomon::NFetcher::NYasm {
namespace {
    struct TMessageStringPool: public IMessageStringPool {
        TMessageStringPool(const TSignalNameTable& signalNameTable, const TInstanceKeyTable& instanceKeyTable)
            : Signals_{signalNameTable.name()}
            , Keys_{instanceKeyTable.name()}
        {
        }

        TStringBuf InstanceKey(const TInstanceKey& instanceKey) const override {
            return Keys_.at(instanceKey.index());
        }

        TStringBuf SignalName(const TSignalName& signal) const override {
            return Signals_.at(signal.index());
        }

    private:
        const google::protobuf::RepeatedPtrField<TString>& Signals_;
        const google::protobuf::RepeatedPtrField<TString>& Keys_;
    };
} // namespace

IMessageStringPoolPtr CreateStringPool(const TSignalNameTable& signalNameTable, const TInstanceKeyTable& instanceKeyTable) {
    return MakeHolder<TMessageStringPool>(signalNameTable, instanceKeyTable);
}

} // namespace NSolomon::NFetcher::NYasm
