#pragma once

#include <util/generic/strbuf.h>

namespace NYasm::NInterfaces::NInternal {
class TInstanceKey;
class TSignalName;
class TSignalNameTable;
class TInstanceKeyTable;
} // namespace NYasm::NInterfaces::NInternal

namespace NSolomon::NFetcher::NYasm {

    class IMessageStringPool {
    public:
        virtual ~IMessageStringPool() = default;
        virtual TStringBuf InstanceKey(const ::NYasm::NInterfaces::NInternal::TInstanceKey& key) const = 0;
        virtual TStringBuf SignalName(const ::NYasm::NInterfaces::NInternal::TSignalName& signal) const = 0;
    };

    using IMessageStringPoolPtr = THolder<IMessageStringPool>;

    IMessageStringPoolPtr CreateStringPool(
            const ::NYasm::NInterfaces::NInternal::TSignalNameTable& signalNameTable,
            const ::NYasm::NInterfaces::NInternal::TInstanceKeyTable& instanceKeyTable);


} // namespace NSolomon::NFetcher::NYasm
