#include "shard_key.h"

#include <solomon/libs/cpp/yasm/group/group.h>

#include <library/cpp/consistent_hashing/consistent_hashing.h>

#include <util/digest/city.h>
#include <util/digest/multi.h>
#include <util/generic/algorithm.h>
#include <util/string/cast.h>

namespace NSolomon::NFetcher::NYasm {

constexpr TStringBuf HOST = "_host_";
constexpr TStringBuf GROUP = "_group_";
constexpr size_t MAX_DIGITS = std::numeric_limits<ui16>::digits10;

TYasmShardKey::TYasmShardKey(TStringBuf itype, TStringBuf host, TStringBuf signalName, ui64 shardCount)
    : ItypeSize_{itype.size()}
{
    ShardId_.reserve(YASM_PREFIX.size() + itype.size() + GROUP.size() + MAX_DIGITS);
    ShardId_.append(YASM_PREFIX);
    ShardId_.append(itype);

    ui64 hashValue;
    if (host.Empty() || NSolomon::NYasm::IsGroupOrMetagroup(host)) {
        ShardId_.append(GROUP);
        hashValue = CityHash64(signalName.data(), signalName.size());
    } else {
        ShardId_.append(HOST);
        hashValue = CombineHashes(CityHash64(host), CityHash64(signalName));
    }

    ui16 num = static_cast<ui16>(ConsistentHashing(hashValue, shardCount));

    // doing ShardId_.append(ToString(num)), but without additional allocation and copy
    size_t prevSize = ShardId_.size();
    ShardId_.resize(prevSize + MAX_DIGITS);
    const auto strLen = ToStringImpl<ui16>(num, ShardId_.begin() + prevSize, MAX_DIGITS);
    ShardId_.resize(prevSize + strLen);
}

size_t TYasmShardKey::Hash() const {
    return CityHash64(ShardId_.data(), ShardId_.size());
}

} // namespace NSolomon::NFetcher::NYasm
