#pragma once

#include <util/generic/string.h>
#include <util/generic/hash.h>

namespace NSolomon::NFetcher::NYasm {

class TYasmShardKey {
    static constexpr TStringBuf YASM_PREFIX = "yasm_";
public:
    TYasmShardKey(TStringBuf itype, TStringBuf host, TStringBuf signalName, ui64 shardCount);

    const std::string& GetShardId() const {
        return ShardId_;
    }

    TStringBuf GetItype() const {
        return TStringBuf{ShardId_.cbegin() + YASM_PREFIX.size(), ItypeSize_};
    }

    TStringBuf GetCluster() const {
        return TStringBuf{ShardId_.cbegin() + YASM_PREFIX.size() + ItypeSize_ + 1, ShardId_.cend()};
    }

    bool operator==(const TYasmShardKey& rhs) const {
        return ShardId_ == rhs.ShardId_;
    }

    size_t Hash() const;

private:
    std::string ShardId_;
    size_t ItypeSize_;
};

} // namespace NSolomon::NFetcher::NYasm

template <>
struct THash<NSolomon::NFetcher::NYasm::TYasmShardKey> {
    size_t operator()(const NSolomon::NFetcher::NYasm::TYasmShardKey& key) const noexcept {
        return key.Hash();
    }
};
