#pragma once

#include <solomon/libs/cpp/string_pool/string_pool.h>

#include <library/cpp/monlib/encode/format.h>
#include <library/cpp/monlib/metrics/metric_type.h>

#include <util/stream/buffer.h>

namespace NYasm::NInterfaces::NInternal {
class TFloatValue;
class TCountedSum;
class THgramSmall;
class THgramNormal;
class TUgram;
} // namespace NYasm::NInterfaces::NInternal

namespace NSolomon::NFetcher::NYasm {

class TStreamSpackEncoder {
public:
    TStreamSpackEncoder()
        : MetricsOut_{MetricsBuf_}
    {
    }

    void AddLabel(TStringBuf name, TStringBuf value);

    void BeginMetric(NMonitoring::EMetricType type);

    void EndMetric();

    void WriteValue(const ::NYasm::NInterfaces::NInternal::TFloatValue& value);

    void WriteValue(const ::NYasm::NInterfaces::NInternal::TCountedSum& value);

    void WriteValue(const ::NYasm::NInterfaces::NInternal::THgramSmall& value);

    void WriteValue(const ::NYasm::NInterfaces::NInternal::THgramNormal& value);

    void WriteValue(const ::NYasm::NInterfaces::NInternal::TUgram& value);

    TString Finish(NMonitoring::ECompression compression);

    void Reset();

private:
    TString Data_;
    TBuffer MetricsBuf_;
    TBufferOutput MetricsOut_;
    NStringPool::TStringPoolBuilder LabelNamesPool_;
    NStringPool::TStringPoolBuilder LabelValuesPool_;
    std::vector<std::pair<ui32, ui32>> Labels_;
    ui32 MetricCount_{0};
};

} // namespace NSolomon::NFetcher::NYasm
