#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/services/fetcher/lib/yasm/common.h>

using namespace NSolomon::NFetcher::NYasm;

namespace {

void Consume(const NMonitoring::TLabels& labels, IMultiShardEncoder& consumer) {
    for (const auto& label: labels) {
        consumer.WriteLabel(label.Name(), label.Value());
    }
}

} // namespace


TEST(TParseCommonRulesTest, Parsing) {
    const auto& table = GetCommonRulesTable(TStringBuf("test_rules.conf"));

    const auto& addrsmiddle = table.at(TStringBuf("addrsmiddle"));
    ASSERT_EQ(addrsmiddle.size(), 0u);

    const auto& runtimecloud = table.at(TStringBuf("runtimecloud"));
    ASSERT_EQ(runtimecloud.size(), 1u);
    ASSERT_EQ(runtimecloud[0].size(), 1u);

    ASSERT_EQ(runtimecloud[0][0].Name(), "tier");
    ASSERT_EQ(runtimecloud[0][0].Value(), "none");

    const auto& searchproxy = table.at(TStringBuf("searchproxy"));
    ASSERT_EQ(searchproxy.size(), 2u);
    ASSERT_EQ(searchproxy[0].size(), 1u);
    ASSERT_EQ(searchproxy[1].size(), 1u);

    ASSERT_EQ(searchproxy[0][0].Name(), "tier");
    ASSERT_EQ(searchproxy[0][0].Value(), "CastorTier");

    ASSERT_EQ(searchproxy[1][0].Name(), "tier");
    ASSERT_EQ(searchproxy[1][0].Value(), "none");
}

TEST(TParseCommonRulesTest, Consumer1) {
    const auto& table = GetCommonRulesTable(TStringBuf("test_rules.conf"));

    const auto& searchproxy = table.at(TStringBuf("searchproxy"));
    TCommonRulesMatchTagsConsumer consumer(searchproxy);

    {
        NMonitoring::TLabels labels{{"cluster", "host_0"}, {"service", "yasm"}, {"tier", "none"}};
        Consume(labels, consumer);
        ASSERT_TRUE(consumer.Match());
        consumer.Reset();
    }

    {
        NMonitoring::TLabels labels{{"cluster", "host_0"}, {"service", "yasm"}, {"tier", "CastorTier"}};
        Consume(labels, consumer);
        ASSERT_TRUE(consumer.Match());
        consumer.Reset();
    }

    {
        NMonitoring::TLabels labels{{"cluster", "host_0"}, {"service", "yasm"}, {"tier", "unknown"}};
        Consume(labels, consumer);
        ASSERT_EQ(false, consumer.Match());
        consumer.Reset();
    }
}

TEST(TParseCommonRulesTest, Consumer2) {
    const auto& table = GetCommonRulesTable(TStringBuf("test_rules.conf"));

    const auto& addrsmiddle = table.at(TStringBuf("addrsmiddle"));

    TCommonRulesMatchTagsConsumer consumer(addrsmiddle);
    NMonitoring::TLabels labels{{"cluster", "host_0"}, {"service", "yasm"}, {"tier", "none"}};

    Consume(labels, consumer);
    ASSERT_TRUE(consumer.Match());
}

TEST(TParseCommonRulesTest, S) {
    const auto& table = GetCommonRulesTable();

    auto it = table.find(TStringBuf("yasmdumper"));
    ASSERT_NE(it, table.end());
}
