#include <solomon/services/fetcher/lib/yasm/hist_builder.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NFetcher::NYasm;
using namespace NMonitoring;

TEST(THistBuilderTest, EmptyHasSingleBucket) {
    THistogramBuilder b{0};
    auto hist = b.Finalize();
    ASSERT_EQ(hist->Count(), 1u);
    ASSERT_EQ(hist->UpperBound(0), HISTOGRAM_INF_BOUND);
    ASSERT_EQ(hist->Value(0), 0u);
}

TEST(THistBuilderTest, ThrowsOnTooManyBuckets) {
    THistogramBuilder b{HISTOGRAM_MAX_BUCKETS_COUNT};
    for (auto i = 0u; i < HISTOGRAM_MAX_BUCKETS_COUNT; ++i) {
        b.Add(i, 1);
    }

    ASSERT_THROW(b.Finalize(), yexception);
}

TEST(THistBuilderTest, CanWriteToInfBucket) {
    THistogramBuilder b{1};
    b.Add(0, 3);
    auto hist = b.Finalize(42);
    ASSERT_EQ(hist->Value(hist->Count() - 1), 42u);
}
