#include <solomon/services/fetcher/lib/yasm/shard_key.h>

#include <infra/yasm/stockpile_client/common/base_types.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NFetcher::NYasm;
using namespace NHistDb::NStockpile;

TEST(TYasmShardKeyTest, Host) {
    TStringBuf itype{"base"};
    TStringBuf host{"fghhvtkdxm6peft.man.yp-c.yandex.net"};
    TStringBuf signal{"cpu-id_hgram"};

    auto expected = TMetabaseShardKey::Make(
            itype,
            NZoom::NHost::THostName{host},
            NZoom::NSignal::TSignalName{signal},
            64);

    TYasmShardKey key{itype, host, signal, 64};

    EXPECT_EQ(key.GetShardId(), expected.GetShardId());
    EXPECT_EQ(key.GetItype(), expected.GetProject());
    EXPECT_EQ(key.GetCluster(), expected.GetCluster());

    EXPECT_EQ(key.GetShardId(), "yasm_base_host_10");
}

TEST(TYasmShardKeyTest, EmptyHost) {
    TStringBuf itype{"base"};
    TStringBuf host;
    TStringBuf signal{"cpu-id_hgram"};

    auto expected = TMetabaseShardKey::Make(
            itype,
            NZoom::NHost::THostName{host},
            NZoom::NSignal::TSignalName{signal},
            64);

    TYasmShardKey key{itype, host, signal, 64};

    EXPECT_EQ(key.GetShardId(), expected.GetShardId());
    EXPECT_EQ(key.GetItype(), expected.GetProject());
    EXPECT_EQ(key.GetCluster(), expected.GetCluster());

    EXPECT_EQ(key.GetShardId(), "yasm_base_group_32");
}

TEST(TYasmShardKeyTest, Group) {
    TStringBuf itype{"base"};
    TStringBuf host{"ASEARCH"};
    TStringBuf signal{"cpu-id_hgram"};

    auto expected = TMetabaseShardKey::Make(
            itype,
            NZoom::NHost::THostName{host},
            NZoom::NSignal::TSignalName{signal},
            64);

    TYasmShardKey key{itype, host, signal, 64};

    EXPECT_EQ(key.GetShardId(), expected.GetShardId());
    EXPECT_EQ(key.GetItype(), expected.GetProject());
    EXPECT_EQ(key.GetCluster(), expected.GetCluster());

    EXPECT_EQ(key.GetShardId(), "yasm_base_group_32");
}
