#include <solomon/services/fetcher/lib/yasm/yasm_decoder.h>
#include <solomon/services/fetcher/lib/yasm/encoder.h>

#include <library/cpp/monlib/encode/spack/spack_v1.h>
#include <library/cpp/monlib/encode/text/text.h>
#include <library/cpp/resource/resource.h>
#include <library/cpp/testing/gtest/gtest.h>

#include <util/generic/hash.h>
#include <util/stream/mem.h>

using namespace NSolomon::NFetcher::NYasm;
using namespace NYasm::NInterfaces::NInternal;
using namespace NMonitoring;

struct TStdOutConsumer: public IDataConsumer {
    void OnShardData(TYasmShardKey key, TString data) override {
        Cout << key.GetItype() << '/' << key.GetCluster() << "\n----------------------------\n";
        auto encoder = EncoderText(&Cout);
        TMemoryInput in{data};
        DecodeSpackV1(&in, encoder.Get());
    }
};

TEST(TDecodeYasmAGentResponseTest, Decode) {
    TString data = NResource::Find("yasm_agent_data.proto");
    NProtoBuf::Arena arena;
    auto* response = NProtoBuf::Arena::CreateMessage<TAgentResponse>(&arena);
    Y_ENSURE(response->ParseFromArray(data.begin(), data.size()), "Cannot parse TAgentResponse message");

    TStdOutConsumer consumer;

    auto decoder = CreateYasmAgentDecoder("iva1-5008.search.yandex.net", CreateMultiShardEncoder(ECompression::IDENTITY));
    decoder->Decode(
            response->GetPerInstanceRecords(),
            response->GetAggregatedRecords(),
            &consumer);
}
