#pragma once

#include "itype_white_list.h"
#include "encoder.h"

#include <infra/yasm/interfaces/internal/agent.pb.h>

#include <library/cpp/monlib/encode/format.h>
#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NYasm {
class IShardConfig;
} // namespace NSolomon::NYasm

namespace NSolomon::NFetcher::NYasm {
    class IMultiShardEncoder;

    struct TShardData {
        TYasmShardKey Key;
        NMonitoring::EFormat Format{NMonitoring::EFormat::UNKNOWN};
        TString Data;
    };

    // TODO: less verbose interface
    TVector<TShardData> DecodeYasmAgentResponse(
        const ::NYasm::NInterfaces::NInternal::TPerInstanceRecords& perInstanceRecords,
        const ::NYasm::NInterfaces::NInternal::TAggregatedRecords& aggregatedRecords,
        const NSolomon::NYasm::IShardConfig& shardConfig,
        THolder<IMultiShardEncoder> encoder,
        TStringBuf hostName = "",
        const IYasmItypeWhiteListPtr& whiteList = nullptr
    );

    class IYasmAgentDecoder: public TThrRefBase {
    public:
        virtual void Decode(
            const ::NYasm::NInterfaces::NInternal::TPerInstanceRecords& perInstanceRecords,
            const ::NYasm::NInterfaces::NInternal::TAggregatedRecords& aggregatedRecords,
            IDataConsumer* consumer) = 0;
    };

    TIntrusivePtr<IYasmAgentDecoder> CreateYasmAgentDecoder(
            TStringBuf hostName,
            THolder<IMultiShardEncoder> encoder,
            IYasmItypeWhiteListPtr whiteList = nullptr);

    TIntrusivePtr<IYasmAgentDecoder> CreateYasmAgentDecoder(
        std::shared_ptr<NSolomon::NYasm::IShardConfig> shardConf,
        THolder<IMultiShardEncoder> encoder,
        TStringBuf hostName,
        IYasmItypeWhiteListPtr whiteList = nullptr);

} // namespace NSolomon::NFetcher::NYasm
