#include "ufetcher_factory.h"

#include <solomon/services/fetcher/lib/data_sink/data_sink.h>
#include <solomon/services/fetcher/lib/dns/continuous_resolver.h>
#include <solomon/services/fetcher/lib/fetcher_shard.h>
#include <solomon/services/fetcher/lib/host_groups/host_and_labels.h>
#include <solomon/services/fetcher/lib/racktables/dc_matcher.h>
#include <solomon/services/fetcher/lib/url/url.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/actors/runtime/actor_runtime.h>
#include <solomon/libs/cpp/dns/dns.h>
#include <solomon/libs/cpp/http/client/curl/client.h>

using namespace NActors;
using namespace NSolomon;
using namespace NMonitoring;

namespace NSolomon::NFetcher {
namespace {
    class TFakeMetrics: public IShardMetrics {
    public:
        void ReportStatus(yandex::solomon::common::UrlStatusType) override {}
        void ReportMetricsParsed(size_t, EDc) override {}
        void ReportResponseSize(size_t, EDc, TStringBuf) override {}

        void ReportUnspecified() override {}
        void ReportFormat(NMonitoring::EFormat, NMonitoring::ECompression) override {}

        void IncDecodeInflight() override {}
        void IncDecodeInflightMultishard() override {}
        void DecDecodeInflight() override {}
        void DecDecodeInflightMultishard() override {}
        void DecodeTime(TDuration) override {}
        void DecodeTimeMultishard(TDuration) override {}

        void AddUrlCount(i64) override {}
        void AddInflight(i64) override {}
        void IncInflight() override {}
        void DecInflight() override {}
        void AddIdle(i32) override {}
        void RecordDownloadDuration(ui64) override {}
        void Postponed() override {}
        void DownloadSuccess() override {}
        void DownloadFail() override {}
        void DownloadTimeout() override {}

        void Accept(TInstant, IMetricConsumer*) const override {
        }

        void Append(TInstant, IMetricConsumer*) const override {
        }
    };

    class TMicroUrlFactory: public IMicroUrlFactory {
    public:
        TMicroUrlFactory(TActorId dnsResolverId, TActorId sinkId, TFetcherShard shard)
            : FetcherUrlFactory_{CreateFetcherUrlFactory(nullptr, {}, TClusterInfo{})}
            , DnsResolverId_{dnsResolverId}
            , SinkId_{sinkId}
            , Shard_{std::move(shard)}
            , HttpClient_{CreateCurlClient({}, Registry_)}
            , Metrics_{std::make_shared<TFakeMetrics>()}
        {
        }

        TActorId CreateUrlActor(TActorRuntime& runtime, THostAndLabels hl) override {
            auto parserId = runtime.Register(FetcherUrlFactory_->CreateUrlParser(Shard_, hl.Host, Metrics_));

            return runtime.Register(::NSolomon::NFetcher::CreateUrlActor(
                std::move(hl),
                Shard_,
                *FetcherUrlFactory_,
                parserId,
                DnsResolverId_,
                SinkId_,
                TActorId{}, // stat collector
                TActorId{}, // auth gatekeeper
                Metrics_,
                CreateFakeLimiter(),
                HttpClient_
            ));
        }

    private:
        std::shared_ptr<IFetcherUrlFactory> FetcherUrlFactory_;
        TActorId DnsResolverId_;
        TActorId SinkId_;
        TFetcherShard Shard_;
        NMonitoring::TMetricRegistry Registry_;
        IHttpClientPtr HttpClient_;
        IShardMetricsPtr Metrics_;
    };
} // namespace
    THolder<IMicroUrlFactory> TMicroUrlFactoryBuilder::Build() {
        std::optional<TFetcherShard> shard;
        switch (Type_) {
            case EFetcherShardType::YasmAgent:
                shard = CreateYasmAgentShard();
                break;
            case EFetcherShardType::Agent:
                shard = CreateAgentShard("foo", TDuration::Seconds(15), {});
                break;
            case EFetcherShardType::Simple:
                ythrow yexception() << "This type of shard is not supported yet";
                break;
        }

        return MakeHolder<TMicroUrlFactory>(DnsResolverId_, DataSinkId_, *shard);
    }

} // namespace NSolomon::NFetcher
