#pragma once

#include <solomon/services/fetcher/lib/host_groups/host_and_labels.h>
#include <solomon/services/fetcher/lib/fetcher_shard.h>

#include <library/cpp/actors/core/actor.h>

namespace NSolomon {
class TActorRuntime;
} // namespace NSolomon

namespace NSolomon::NFetcher {
    class IMicroUrlFactory {
    public:
        virtual ~IMicroUrlFactory() = default;
        virtual NActors::TActorId CreateUrlActor(TActorRuntime& runtime, THostAndLabels hl) = 0;
    };

    class TMicroUrlFactoryBuilder {
    public:
        TMicroUrlFactoryBuilder& WithShardType(EFetcherShardType type) {
            Type_ = type;
            return *this;
        }

        TMicroUrlFactoryBuilder& WithDataSinkId(NActors::TActorId dataSink) {
            DataSinkId_ = dataSink;
            return *this;
        }

        TMicroUrlFactoryBuilder& WithDnsResolverId(NActors::TActorId resolver) {
            DnsResolverId_ = resolver;
            return *this;
        }

        THolder<IMicroUrlFactory> Build();

    private:
        EFetcherShardType Type_;
        NActors::TActorId DataSinkId_;
        NActors::TActorId DnsResolverId_;
    };
} // namespace NSolomon
