package ru.yandex.solomon.alert.gateway.dto;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.protobuf.TTelegramGroupTitlesResponse;

/**
 * @author Oleg Baryshnikov
 */
@ApiModel("TelegramGroupTitlesResponseDto")
@ParametersAreNonnullByDefault
public class TelegramGroupTitlesResponseDto {

    @JsonProperty("RequestStatus")
    public String requestStatus;

    @JsonProperty("GroupTitle")
    public List<String> groupTitle;

    @JsonProperty("StatusMessage")
    public String statusMessage;

    public static TelegramGroupTitlesResponseDto fromModel(TTelegramGroupTitlesResponse model) {
        TelegramGroupTitlesResponseDto dto = new TelegramGroupTitlesResponseDto();
        dto.requestStatus = model.getRequestStatus().name();
        dto.groupTitle = model.getGroupTitleList();
        dto.statusMessage = model.getStatusMessage();
        return dto;
    }
}
