package ru.yandex.solomon.alert.gateway.dto;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.protobuf.TYaChatsGroupInfo;
import ru.yandex.solomon.alert.protobuf.TYaChatsGroupsResponse;

/**
 * @author Nikita Minin
 */
@ApiModel("YaChatsGroupsResponseDto")
@ParametersAreNonnullByDefault
public class YaChatsGroupsResponseDto {

    public String requestStatus;

    @JsonProperty
    public List<TYaChatsGroupInfo> groups;

    @JsonProperty
    public String statusMessage;

    public static YaChatsGroupsResponseDto fromModel(TYaChatsGroupsResponse model) {
        YaChatsGroupsResponseDto dto = new YaChatsGroupsResponseDto();
        dto.requestStatus = model.getRequestStatus().name();
        dto.groups = model.getGroupsList();
        dto.statusMessage = model.getStatusMessage();
        return dto;
    }
}
