package ru.yandex.solomon.alert.gateway.dto.alert;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.gateway.dto.alert.state.AlertEvaluationStatusDto;
import ru.yandex.solomon.alert.protobuf.TExplainEvaluationResponse;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel("AlertExplainEvaluation")
@JsonInclude(JsonInclude.Include.NON_NULL)
@ParametersAreNullableByDefault
public class AlertExplainEvaluationDto {
    @ApiModelProperty(
            value = "Evaluation status and details",
            required = true,
            position = 1)
    public AlertEvaluationStatusDto status;

    @ApiModelProperty(
            value = "Time series that was use during check evaluation status",
            required = false,
            position = 2
    )
    public List<AlertTimeSeriesDto> series;

    @Nonnull
    public static AlertExplainEvaluationDto fromProto(@Nonnull TExplainEvaluationResponse proto) {
        AlertExplainEvaluationDto dto = new AlertExplainEvaluationDto();
        dto.status = AlertEvaluationStatusDto.fromProto(proto.getEvaluationStatus());
        dto.series = proto.getSeriesList()
                .stream()
                .map(AlertTimeSeriesDto::fromProto)
                .collect(Collectors.toList());
        return dto;
    }
}
