package ru.yandex.solomon.alert.gateway.dto.alert;

import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.gateway.dto.TokenBasePage;
import ru.yandex.solomon.alert.protobuf.TListAlertResponse;

import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "AlertFullPage", parent = TokenBasePage.class)
public class AlertFullList extends TokenBasePage<AlertDto> {
    public static AlertFullList fromProto(TListAlertResponse proto) {
        if (proto.getResultCase() != TListAlertResponse.ResultCase.ALERT_LIST) {
            throw new IllegalArgumentException("can't convert result from " + proto.getResultCase());
        }
        AlertFullList result = new AlertFullList();
        result.items = proto.getAlertList().getAlertsList()
                .stream()
                .map(AlertDto::fromProto)
                .collect(toList());
        result.nextPageToken = proto.getNextPageToken();
        return result;
    }
}
