package ru.yandex.solomon.alert.gateway.dto.alert;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TReadAlertInterpolatedResponse;

/**
 * @author Alexey Trushkin
 */
@ApiModel("AlertInterpolatedResponse")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AlertInterpolatedResponse {

    @ApiModelProperty(
            value = "Alert",
            readOnly = true,
            required = true)
    public AlertDto alert;

    @ApiModelProperty(
            value = "Interpolated version of alert",
            readOnly = true,
            required = true)
    public AlertDto interpolatedAlert;

    public static AlertInterpolatedResponse fromProto(TReadAlertInterpolatedResponse proto) {
        AlertInterpolatedResponse response = new AlertInterpolatedResponse();
        response.alert = AlertDto.fromProto(proto.getAlert());
        response.interpolatedAlert = AlertDto.fromProto(proto.getInterpolatedAlert());
        return response;
    }
}
