package ru.yandex.solomon.alert.gateway.dto.alert;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.ListAlertLabelsResponse;

/**
 * @author Alexey Trushkin
 */
@ApiModel("AlertLabelsDto")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AlertLabelsDto {
    @ApiModelProperty(
            value = "Alert label keys in project",
            required = true,
            position = 1)
    public List<String> labels;

    public static AlertLabelsDto fromProto(@Nonnull ListAlertLabelsResponse proto) {
        AlertLabelsDto dto = new AlertLabelsDto();
        dto.labels = proto.getLabelKeysList();
        return dto;
    }
}
