package ru.yandex.solomon.alert.gateway.dto.alert;

import java.util.List;

import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.gateway.dto.TokenBasePage;
import ru.yandex.solomon.alert.protobuf.TListAlert;
import ru.yandex.solomon.alert.protobuf.TListAlertResponse;

import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "AlertPage", parent = TokenBasePage.class)
public class AlertList extends TokenBasePage<AlertListItemDto> {
    public static AlertList fromProto(TListAlertResponse proto) {
        if (proto.getResultCase() != TListAlertResponse.ResultCase.LIST_ALERT_LIST) {
            if (proto.getResultCase() == TListAlertResponse.ResultCase.RESULT_NOT_SET) {
                return response(proto, proto.getAlertsList());
            }
            throw new IllegalArgumentException("can't convert result from " + proto.getResultCase());
        }
        return response(proto, proto.getListAlertList().getAlertsList());
    }

    private static AlertList response(TListAlertResponse proto, List<TListAlert> alertsList) {
        AlertList result = new AlertList();
        result.items = alertsList
                .stream()
                .map(AlertListItemDto::fromProto)
                .collect(toList());
        result.nextPageToken = proto.getNextPageToken();
        return result;
    }
}
