package ru.yandex.solomon.alert.gateway.dto.alert;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.DeployAlertTemplateResponse;

/**
 * @author Alexey Trushkin
 */
@ApiModel("AlertTemplateDeploy")
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AlertTemplateDeployDto {
    @ApiModelProperty(
            value = "deploy task id",
            required = true)
    public String taskId;

    public static AlertTemplateDeployDto fromProto(DeployAlertTemplateResponse response) {
        AlertTemplateDeployDto dto = new AlertTemplateDeployDto();
        dto.taskId = response.getTaskId();
        return dto;
    }
}
