package ru.yandex.solomon.alert.gateway.dto.alert;

import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.gateway.dto.TokenBasePage;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateResponse;

import static java.util.stream.Collectors.toList;

/**
 * @author Alexey Trushkin
 */
@ApiModel(value = "AlertTemplatePage", parent = TokenBasePage.class)
public class AlertTemplateList extends TokenBasePage<AlertTemplateDto> {
    public static AlertTemplateList fromProto(ListAlertTemplateResponse proto) {
        AlertTemplateList result = new AlertTemplateList();
        result.items = proto.getAlertTemplatesList()
                .stream()
                .map(AlertTemplateDto::fromProto)
                .collect(toList());
        result.nextPageToken = proto.getNextPageToken();
        return result;
    }
}
