package ru.yandex.solomon.alert.gateway.dto.alert;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TAlertTimeSeries;
import ru.yandex.solomon.labels.protobuf.LabelConverter;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel("AlertTimeSeries")
@JsonInclude(JsonInclude.Include.NON_NULL)
@ParametersAreNullableByDefault
public class AlertTimeSeriesDto {
    @ApiModelProperty(
            value = "Alias of timeseries, or empty if not specified",
            required = false,
            position = 1)
    public String alias;

    @ApiModelProperty(
            value = "Labels of timeseries, or empty if absent by any reason",
            required = false,
            position = 2)
    public Map<String, String> labels;

    @ApiModelProperty(
            value = "Array with timestamps of timeseries",
            required = false,
            position = 3)
    public long[] timestamps;

    @ApiModelProperty(
            value = "Array with values of timeseries",
            required = false,
            position = 3)
    public double[] values;

    @Nonnull
    public static AlertTimeSeriesDto fromProto(@Nonnull TAlertTimeSeries proto) {
        AlertTimeSeriesDto dto = new AlertTimeSeriesDto();
        dto.alias = proto.getAlias();
        dto.labels = LabelConverter.protoToLabels(proto.getLabelsList()).toMap();
        // Awful protobuf store primitive values as boxed types
        // https://github.com/google/protobuf/issues/3316
        dto.timestamps = proto.getTimeMillisList().stream().mapToLong(value -> value).toArray();
        dto.values = proto.getValuesList().stream().mapToDouble(value -> value).toArray();
        return dto;
    }
}
