package ru.yandex.solomon.alert.gateway.dto.alert;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author Alexey Trushkin
 */
@ApiModel("CreateAlertsFromTemplateResponse")
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreateAlertsFromTemplateResponse {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    @ApiModelProperty(
            value = "Created alerts",
            position = 1)
    public List<CreatedAlert> alerts = new ArrayList<>();

    public static CreateAlertsFromTemplateResponse fromProto(ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateResponse proto) {
        CreateAlertsFromTemplateResponse response = new CreateAlertsFromTemplateResponse();
        for (ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateResponse.Alert alert : proto.getAlertsList()) {
            CreatedAlert a = new CreatedAlert();
            a.templateId = alert.getTemplateId();
            a.alertId = alert.getAlertId();
            try {
                a.resourceRow = MAPPER.writeValueAsString(alert.getResourceParametersMap());
            } catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            response.alerts.add(a);
        }
        return response;
    }

    @ApiModel("CreatedAlert")
    @ParametersAreNonnullByDefault
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class CreatedAlert {
        @ApiModelProperty(
                value = "Created alert Id",
                position = 1)
        public String alertId;

        @ApiModelProperty(
                value = "Resource row",
                position = 2)
        public String resourceRow;

        @ApiModelProperty(
                value = "Alert template Id",
                position = 3)
        public String templateId;
    }
}
