package ru.yandex.solomon.alert.gateway.dto.alert;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.protobuf.TEvaluationStats;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel("EvaluationStatistics")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
public class EvaluationStatsDto {
    public long noData;
    public long ok;
    public long error;
    public long alarm;
    public long warn;

    public static EvaluationStatsDto fromProto(@Nonnull TEvaluationStats proto) {
        EvaluationStatsDto dto = new EvaluationStatsDto();
        dto.noData = proto.getCountNoData();
        dto.ok = proto.getCountOk();
        dto.error = proto.getCountError();
        dto.alarm = proto.getCountAlarm();
        dto.warn = proto.getCountWarn();
        return dto;
    }
}
