package ru.yandex.solomon.alert.gateway.dto.alert;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.Expression;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Alexey Trushkin
 */
@ApiModel(value = "ExpressionAlertTemplate")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ExpressionAlertTemplateDto {
    @ApiModelProperty(
            value = "contains expression to evaluate",
            example = "let started = {project=solomon, service=test, sensor=requestStarted, host!=cluster};\n" +
                    "let completed = {project=solomon, service=test, sensor=requestCompleted, host!=cluster};\n" +
                    "let inFlight = started - completed;")
    public String program;

    public static ExpressionAlertTemplateDto fromProto(Expression expression) {
        ExpressionAlertTemplateDto dto = new ExpressionAlertTemplateDto();
        dto.program = expression.getProgram();
        return dto;
    }

    public Expression toProto() {
        return Expression.newBuilder()
                .setProgram(Nullables.orEmpty(program))
                .build();
    }
}
