package ru.yandex.solomon.alert.gateway.dto.alert;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TExpression;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "TExpression")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ExpressionDto {
    @ApiModelProperty(
            value = "contains expression to evaluate",
            example = "let started = {project=solomon, service=test, sensor=requestStarted, host!=cluster};\n" +
                    "let completed = {project=solomon, service=test, sensor=requestCompleted, host!=cluster};\n" +
                    "let inFlight = started - completed;",
            required = false,
            position = 0)
    public String program;

    @ApiModelProperty(
            value = "TExpression that as a result evaluation should return boolean value, " +
                    "where true it's ALARM, false it's OK. TExpression can use variable from program.",
            example = "min({project=kikimr, cluster=foo, service=bar, sensor=idleTime, host='kikimr-01'}) <= 5",
            required = true,
            position = 1)
    public String checkExpression;

    public static ExpressionDto fromProto(TExpression expression) {
        ExpressionDto dto = new ExpressionDto();
        dto.program = expression.getProgram();
        dto.checkExpression = expression.getCheckExpression();
        return dto;
    }

    public TExpression toProto() {
        return TExpression.newBuilder()
                .setProgram(Nullables.orEmpty(program))
                .setCheckExpression(Nullables.orEmpty(checkExpression))
                .build();
    }
}
