package ru.yandex.solomon.alert.gateway.dto.alert;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.protobuf.TNotificationStats;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel("NotificationStatistics")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
public class NotificationStatsDto {
    public long unknown;
    public long success;
    public long error;
    public long invalidRequest;
    public long absentNotificationChannel;
    public long retryError;
    public long resourceExhausted;
    public long permissionDenied;

    public static NotificationStatsDto fromProto(@Nonnull TNotificationStats proto) {
        NotificationStatsDto dto = new NotificationStatsDto();
        dto.unknown = proto.getCountUnknown();
        dto.success = proto.getCountSuccess();
        dto.error = proto.getCountError();
        dto.invalidRequest = proto.getCountInvalidRequest();
        dto.absentNotificationChannel = proto.getCountAbsentNotificationChannel();
        dto.retryError = proto.getCountRetryError();
        dto.resourceExhausted = proto.getCountResourceExhausted();
        dto.permissionDenied = proto.getCountPermissionDenied();
        return dto;
    }
}
