package ru.yandex.solomon.alert.gateway.dto.alert;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.ECompare;
import ru.yandex.solomon.alert.protobuf.EThresholdType;
import ru.yandex.solomon.alert.protobuf.TPredicateRule;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Ivan Tsybulin
 */
@ApiModel(value = "PredicateRule")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PredicateRuleDto {
    @ApiModelProperty(
            value = "Criteria by which the alert will be checked",
            required = true,
            position = 0)
    public EThresholdType thresholdType;

    @ApiModelProperty(
            value = "Operation used to compare with threshold value",
            required = true,
            position = 1)
    public ECompare comparison;

    @ApiModelProperty(
            value = "Threshold value",
            required = true,
            position = 2)
    public Double threshold;

    @ApiModelProperty(
            value = "Target status of the alert if the predicate is true",
            required = true,
            position = 3)
    public TPredicateRule.ETargetStatus targetStatus;

    public static PredicateRuleDto fromProto(@Nonnull TPredicateRule proto) {
        PredicateRuleDto dto = new PredicateRuleDto();

        dto.thresholdType = proto.getThresholdType();
        dto.comparison = proto.getComparison();
        dto.threshold = proto.getThreshold();
        dto.targetStatus = proto.getTargetStatus();

        return dto;
    }

    public TPredicateRule toProto() {
        return TPredicateRule.newBuilder()
                .setThresholdType(Nullables.orDefault(thresholdType, EThresholdType.UNRECOGNIZED))
                .setComparison(Nullables.orDefault(comparison, ECompare.UNRECOGNIZED))
                .setThreshold(Nullables.orDefault(threshold, 0d))
                .setTargetStatus(Nullables.orDefault(targetStatus, TPredicateRule.ETargetStatus.ALARM))
                .build();
    }
}
