package ru.yandex.solomon.alert.gateway.dto.alert;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TReadProjectStatsResponse;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel("ProjectStatistics")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ProjectStatsDto {
    @ApiModelProperty(
            value = "Summary of evaluation by all alerts into project",
            required = true,
            position = 1)
    public EvaluationStatsDto evaluationSummary;

    @ApiModelProperty(
            value = "Summary of notification by all alerts into project",
            required = true,
            position = 2)
    public NotificationStatsDto notificationSummary;

    @ApiModelProperty(
        value = "Alerts count in project",
        required = true,
        position = 3)
    public int alertsCount;

    public static ProjectStatsDto fromProto(@Nonnull TReadProjectStatsResponse proto) {
        ProjectStatsDto dto = new ProjectStatsDto();
        dto.evaluationSummary = EvaluationStatsDto.fromProto(proto.getEvaluationStats());
        dto.notificationSummary = NotificationStatsDto.fromProto(proto.getNotificationStats());
        dto.alertsCount = proto.getAlertsCount();
        return dto;
    }
}
