package ru.yandex.solomon.alert.gateway.dto.alert;

import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.gateway.dto.TokenBasePage;
import ru.yandex.solomon.alert.protobuf.TListSubAlertResponse;

import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "SubAlertPage", parent = TokenBasePage.class)
public class SubAlertList extends TokenBasePage<SubAlertListItemDto> {

    public static SubAlertList fromProto(TListSubAlertResponse proto) {
        SubAlertList result = new SubAlertList();
        result.items = proto.getAlertsList()
                .stream()
                .map(SubAlertListItemDto::fromProto)
                .collect(toList());
        result.nextPageToken = proto.getNextPageToken();
        return result;
    }
}
