package ru.yandex.solomon.alert.gateway.dto.alert;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.ECompare;
import ru.yandex.solomon.alert.protobuf.EThresholdType;
import ru.yandex.solomon.alert.protobuf.PredicateRule;
import ru.yandex.solomon.alert.protobuf.TPredicateRule;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Alexey Trushkin
 */
@ApiModel(value = "TemplatePredicateRule")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TemplatePredicateRuleDto {

    @ApiModelProperty(
            value = "Criteria by which the alert will be checked",
            required = true)
    public EThresholdType thresholdType;

    @ApiModelProperty(
            value = "Operation used to compare with threshold value",
            required = true)
    public ECompare comparison;

    @ApiModelProperty(
            value = "Threshold value",
            required = true)
    public Double threshold;

    @ApiModelProperty(
            value = "Target status of the alert if the predicate is true",
            required = true)
    public TPredicateRule.ETargetStatus targetStatus;

    @ApiModelProperty(
            value = "Threshold parameter mustache template")
    public String thresholdParameterTemplate;

    public static TemplatePredicateRuleDto fromProto(@Nonnull PredicateRule proto) {
        TemplatePredicateRuleDto dto = new TemplatePredicateRuleDto();

        dto.thresholdType = proto.getThresholdType();
        dto.comparison = proto.getComparison();
        dto.threshold = proto.getThreshold();
        dto.targetStatus = proto.getTargetStatus();
        dto.thresholdParameterTemplate = proto.getThresholdParameterTemplate();

        return dto;
    }

    public PredicateRule toProto() {
        return PredicateRule.newBuilder()
                .setThresholdType(Nullables.orDefault(thresholdType, EThresholdType.UNRECOGNIZED))
                .setComparison(Nullables.orDefault(comparison, ECompare.UNRECOGNIZED))
                .setThreshold(Nullables.orDefault(threshold, 0d))
                .setTargetStatus(Nullables.orDefault(targetStatus, TPredicateRule.ETargetStatus.ALARM))
                .setThresholdParameterTemplate(Nullables.orEmpty(thresholdParameterTemplate))
                .build();
    }
}
