package ru.yandex.solomon.alert.gateway.dto.alert.state;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.gateway.dto.alert.EvaluationStatsDto;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStatsResponse;

/**
 * @author Oleg Baryshnikov
 */
@ApiModel("AlertEvaluationStats")
@JsonInclude(JsonInclude.Include.NON_NULL)
@ParametersAreNullableByDefault
public class AlertEvaluationStatsDto {

    @ApiModelProperty(
        value = "Statistic about alert evaluation, for multi alert statistic will contains count sub alerts in particular state",
        required = true)
    public EvaluationStatsDto evaluationStats;

    @Nonnull
    public static AlertEvaluationStatsDto fromProto(TReadEvaluationStatsResponse proto) {
        AlertEvaluationStatsDto dto = new AlertEvaluationStatsDto();
        dto.evaluationStats = EvaluationStatsDto.fromProto(proto.getStats());
        return dto;
    }
}
