package ru.yandex.solomon.alert.gateway.dto.alert.state;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import ru.yandex.solomon.alert.protobuf.TEvaluationStatus;

/**
 * @author Vladimir Gordiychuk
 */
public class AlertEvaluationStatusDto {
    public TEvaluationStatus.ECode code;
    public String description;
    public Map<String, String> annotations;
    public Map<String, String> serviceProviderAnnotations;
    public List<ScalarValue> scalarValues;

    public static AlertEvaluationStatusDto fromProto(@Nonnull TEvaluationStatus proto) {
        AlertEvaluationStatusDto dto = new AlertEvaluationStatusDto();
        dto.code = proto.getCode();
        dto.description = proto.getDesctiption();
        dto.annotations = proto.getAnnotationsMap();
        dto.serviceProviderAnnotations = proto.getServiceProviderAnnotationsMap();
        dto.scalarValues = proto.getScalarValuesList().stream()
                .map(AlertEvaluationStatusDto::fromProto)
                .collect(Collectors.toList());
        return dto;
    }

    private static ScalarValue fromProto(@Nonnull TEvaluationStatus.ScalarValue proto) {
        ScalarValue v = new ScalarValue();
        v.name = proto.getName();
        switch (proto.getValueCase()) {
            case DOUBLE_VALUE -> {
                v.value = proto.getDoubleValue();
                v.type = ScalarType.DOUBLE;
            }
            case BOOL_VALUE -> {
                v.value = proto.getBoolValue();
                v.type = ScalarType.BOOLEAN;
            }
            case STRING_VALUE -> {
                v.value = proto.getStringValue();
                v.type = ScalarType.STRING;
            }
        }
        return v;
    }

    public enum ScalarType {
        STRING,
        DOUBLE,
        BOOLEAN,
    }

    public static class ScalarValue {
        public String name;
        public Object value;
        public ScalarType type;
    }
}
