package ru.yandex.solomon.alert.gateway.dto.alert.state;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.AffectingMute;
import ru.yandex.solomon.alert.protobuf.AlertMuteStatus;
import ru.yandex.solomon.alert.protobuf.MuteStatus;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("AlertMuteStatus")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@ParametersAreNullableByDefault
public class AlertMuteStatusDto {

    @ApiModelProperty(
            value = "Mute status code",
            required = true)
    public AlertMuteStatus.Code code;

    @ApiModelProperty(
            value = "List of related mutes")
    public List<AffectingMuteDto> affectingMutes;

    @Nonnull
    public static AlertMuteStatusDto fromProto(@Nonnull AlertMuteStatus proto) {
        var dto = new AlertMuteStatusDto();
        dto.code = proto.getCode();
        dto.affectingMutes = proto.getAffectingMutesList().stream()
                .map(AffectingMuteDto::fromProto)
                .collect(Collectors.toUnmodifiableList());
        return dto;
    }

    public static class AffectingMuteDto {
        @ApiModelProperty(
                value = "Mute id",
                required = true)
        public String muteId;

        @ApiModelProperty(
                value = "Mute status",
                required = true)
        public MuteStatus status;

        public static AffectingMuteDto fromProto(@Nonnull AffectingMute proto) {
            var dto = new AffectingMuteDto();
            dto.muteId = proto.getId();
            dto.status = proto.getStatus();
            return dto;
        }
    }
}
