package ru.yandex.solomon.alert.gateway.dto.alert.state;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.gateway.dto.alert.NotificationStatsDto;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStatsResponse;

/**
 * @author Oleg Baryshnikov
 */
@ApiModel("AlertNotificationStats")
@JsonInclude(JsonInclude.Include.NON_NULL)
@ParametersAreNullableByDefault
public class AlertNotificationStatsDto {

    @ApiModelProperty(
        value = "Statistic about alert notification",
        required = true)
    public NotificationStatsDto notificationStats;

    @Nonnull
    public static AlertNotificationStatsDto fromProto(@Nonnull TReadNotificationStatsResponse proto) {
        AlertNotificationStatsDto dto = new AlertNotificationStatsDto();
        dto.notificationStats = NotificationStatsDto.fromProto(proto.getStats());
        return dto;
    }
}
