package ru.yandex.solomon.alert.gateway.dto.mute;

import java.util.stream.Collectors;

import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.gateway.dto.TokenBasePage;
import ru.yandex.solomon.alert.protobuf.ListMutesResponse;

/**
 * @author Ivan Tsybulin
 */
@ApiModel(value = "MutesList", parent = TokenBasePage.class)
public class MuteListDto extends TokenBasePage<MuteDto> {
    public static MuteListDto fromProto(ListMutesResponse response) {
        var dto = new MuteListDto();
        dto.items = response.getMutesList().stream()
                .map(MuteDto::fromProto)
                .collect(Collectors.toUnmodifiableList());
        dto.nextPageToken = response.getNextPageToken();
        return dto;
    }
}
