package ru.yandex.solomon.alert.gateway.dto.mute;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.protobuf.MutesStats;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("MuteStats")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
public class MuteStatsDto {
    public long pending;
    public long active;
    public long expired;
    public long archived;

    public static MuteStatsDto fromProto(@Nonnull MutesStats proto) {
        var dto = new MuteStatsDto();

        dto.pending = proto.getCountPending();
        dto.active = proto.getCountActive();
        dto.expired = proto.getCountExpired();
        dto.archived = proto.getCountArchived();

        return dto;
    }
}
