package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TCloudEmailType;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "CloudEmail")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CloudEmailMethod {
    @ApiModelProperty(value = "List of iam ids that should receive notifications", required = true)
    public List<String> iamRecipients = Collections.emptyList();

    static CloudEmailMethod fromProto(@Nonnull TCloudEmailType email) {
        CloudEmailMethod config = new CloudEmailMethod();
        config.iamRecipients = ImmutableList.copyOf(email.getRecipientsList());
        return config;
    }

    public TCloudEmailType toProto() {
        return TCloudEmailType.newBuilder()
            .addAllRecipients(Nullables.orEmpty(iamRecipients))
            .build();
    }
}
