package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TCloudPushType;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Ivan Tsybulin
 */
@ApiModel(value = "CloudPush")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CloudPushMethod {
    @ApiModelProperty(value = "List of iam ids that should receive notifications", required = true)
    public List<String> iamRecipients = Collections.emptyList();

    static CloudPushMethod fromProto(@Nonnull TCloudPushType sms) {
        CloudPushMethod config = new CloudPushMethod();
        config.iamRecipients = ImmutableList.copyOf(sms.getRecipientsList());
        return config;
    }

    public TCloudPushType toProto() {
        return TCloudPushType.newBuilder()
            .addAllRecipients(Nullables.orEmpty(iamRecipients))
            .build();
    }
}
