package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TCloudSmsType;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "CloudSms")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CloudSmsMethod {
    @ApiModelProperty(value = "List of iam ids that should receive notifications", required = true)
    public List<String> iamRecipients = Collections.emptyList();

    static CloudSmsMethod fromProto(@Nonnull TCloudSmsType sms) {
        CloudSmsMethod config = new CloudSmsMethod();
        config.iamRecipients = ImmutableList.copyOf(sms.getRecipientsList());
        return config;
    }

    public TCloudSmsType toProto() {
        return TCloudSmsType.newBuilder()
            .addAllRecipients(Nullables.orEmpty(iamRecipients))
            .build();
    }
}
