package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TDatalensEmailType;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "DatalensEmail")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class DatalensEmailMethod {
    @ApiModelProperty(value = "List of email addresses that should receive notifications", required = true)
    public List<String> recipients = Collections.emptyList();

    static DatalensEmailMethod fromProto(@Nonnull TDatalensEmailType email) {
        DatalensEmailMethod config = new DatalensEmailMethod();
        config.recipients = List.copyOf(email.getRecipientsList());
        return config;
    }

    public TDatalensEmailType toProto() {
        return TDatalensEmailType.newBuilder()
            .addAllRecipients(Nullables.orEmpty(recipients))
            .build();
    }
}
