package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TEmailType;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel(value = "email")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EmailMethod {
    @ApiModelProperty(value = "Mustache template for subject attribute of email, if not specified will be use global template",
            example = "\"[{{status.code}}]: {{alert.name}}\"")
    public String subjectTemplate;
    @ApiModelProperty(value = "Mustache template for email body, if not specified will be use global template",
            example = "\"Everything is broken : {{status.code}}!\"")
    public String contentTemplate;
    @ApiModelProperty(value = "List of email's that should receive notifications", required = true)
    public List<String> recipients = Collections.emptyList();

    static EmailMethod fromProto(@Nonnull TEmailType email) {
        EmailMethod config = new EmailMethod();
        config.contentTemplate = email.getContentTemplate();
        config.subjectTemplate = email.getSubjectTemplate();
        config.recipients = ImmutableList.copyOf(email.getRecipientsList());
        return config;
    }

    public TEmailType toProto() {
        return TEmailType.newBuilder()
                .setSubjectTemplate(Nullables.orEmpty(subjectTemplate))
                .setContentTemplate(Nullables.orEmpty(contentTemplate))
                .addAllRecipients(Nullables.orEmpty(recipients))
                .build();
    }
}
