package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.EscalationView;

/**
 * @author Alexey Trushkin
 */
@ApiModel("NotificationChannel")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EscalationDto {
    @ApiModelProperty(
            value = "unique identity for escalation",
            readOnly = true,
            required = true,
            example = "d7d55c93-66aa-434d-b56c-f8b28c26cce4",
            position = 0)
    public String id;

    @ApiModelProperty(
            value = "ProjectId own this escalation",
            readOnly = true,
            required = true,
            example = "solomon",
            position = 1)
    public String projectId;

    @ApiModelProperty(
            value = "Human-readable name of escalation",
            required = true,
            example = "@telegram-oops",
            position = 2)
    public String title;

    public static EscalationDto fromProto(@Nonnull EscalationView proto, String projectId) {
        EscalationDto dto = new EscalationDto();
        dto.id = proto.getId();
        dto.projectId = projectId;
        dto.title = proto.getTitle();
        return dto;
    }
}
