package ru.yandex.solomon.alert.gateway.dto.notificationChannel;

import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.alert.gateway.dto.TokenBasePage;
import ru.yandex.solomon.alert.protobuf.TListEscalationsResponse;

import static java.util.stream.Collectors.toList;

/**
 * @author Alexey Trushkin
 */
@ApiModel(value = "EscalationPage", parent = TokenBasePage.class)
public class EscalationList extends TokenBasePage<EscalationDto> {
    public static EscalationList fromProto(TListEscalationsResponse proto, String projectId) {
        EscalationList result = new EscalationList();
        result.items = proto.getEscalationViewsList()
                .stream()
                .map(view -> EscalationDto.fromProto(view, projectId))
                .collect(toList());
        return result;
    }
}
